/*
 * Decompiled with CFR 0.152.
 */
package jgamebase.plugins.musicinfo;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import jgamebase.Const;
import jgamebase.plugins.MusicInfo;

public class SID
implements MusicInfo {
    private static final String[] supportedExtensions = new String[]{"sid", "psid"};
    private static final String IDENTIFIER1 = "PSID";
    private static final String IDENTIFIER2 = "RSID";
    private static final int OFFSET_START = 0;
    private static final int OFFSET_IDENTIFIER = 0;
    private static final int OFFSET_VERSION = 4;
    private static final int OFFSET_SONGNUMBER = 14;
    private static final int OFFSET_DEFAULTSONG = 16;
    private static final int OFFSET_NAME = 22;
    private static final int OFFSET_AUTHOR = 54;
    private static final int OFFSET_COPYRIGHT = 86;
    private static final int OFFSET_END = 118;
    private String songNumber;
    private String defaultSong;
    private String name;
    private String author;
    private String copyright;
    byte[] buffer;

    public SID() {
        Const.log.info((Object)"Loaded plugin: music info 'SID'.");
    }

    @Override
    public void load(File file) throws IOException {
        String identifier;
        int read;
        block11: {
            if (file == null) {
                return;
            }
            this.buffer = new byte[118];
            if (!file.exists()) {
                throw new FileNotFoundException(file.getName());
            }
            FileInputStream in = null;
            read = 0;
            try {
                try {
                    in = new FileInputStream(file);
                    read = in.read(this.buffer, 0, 118);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (in != null) {
                        in.close();
                    }
                    break block11;
                }
            }
            catch (Throwable throwable) {
                if (in != null) {
                    in.close();
                }
                throw throwable;
            }
            if (in != null) {
                in.close();
            }
        }
        if (!(identifier = this.bufferToString(0, 4)).equals(IDENTIFIER1) && !identifier.equals(IDENTIFIER2) || read < 118) {
            throw new FileNotFoundException(file.getName());
        }
        this.songNumber = Integer.toString(this.buffer[14] * 256 + this.buffer[15]);
        this.defaultSong = Integer.toString(this.buffer[16] * 256 + this.buffer[17]);
        this.name = this.bufferToString(22, 54).trim();
        this.author = this.bufferToString(54, 86).trim();
        this.copyright = this.bufferToString(86, 118).trim();
    }

    private String bufferToString(int start, int end) {
        StringBuilder s = new StringBuilder();
        int i = start;
        while (i < end) {
            s.append((char)this.buffer[i]);
            ++i;
        }
        return s.toString();
    }

    @Override
    public String[] getSupportedExtensions() {
        return supportedExtensions;
    }

    @Override
    public boolean supportsExtension(String extensionToFind) {
        extensionToFind = extensionToFind.toLowerCase();
        String[] stringArray = supportedExtensions;
        int n = supportedExtensions.length;
        int n2 = 0;
        while (n2 < n) {
            String supportedExtension = stringArray[n2];
            String extension = supportedExtension.toLowerCase();
            if (extension.equals(extensionToFind)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public String getAuthor() {
        return this.author == null ? "" : this.author;
    }

    @Override
    public String getCopyright() {
        return this.copyright == null ? "" : this.copyright;
    }

    @Override
    public String getDefaultSong() {
        return this.defaultSong == null ? "" : this.defaultSong;
    }

    @Override
    public String getName() {
        return this.name == null ? "" : this.name;
    }

    @Override
    public String getSongNumber() {
        return this.songNumber == null ? "" : this.songNumber;
    }
}

